/*
Copyright Renaud GICQUEL 2005  
renaud.gicquel@ensmp.fr

Ce logiciel est un programme informatique servant  modliser des systmes nergtiques.   

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et respectant les principes de diffusion des logiciels libres. Vous pouvez utiliser, modifier et/ou redistribuer ce programme sous les conditions de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA  sur le site "http://www.cecill.info".  

En contrepartie de l'accessibilit au code source et des droits de copie, de modification et de redistribution accords par cette licence, il n'est offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons, seule une responsabilit restreinte pse sur l'auteur du programme,  le titulaire des droits patrimoniaux et les concdants successifs.  

A cet gard  l'attention de l'utilisateur est attire sur les risques associs au chargement,   l'utilisation,   la modification et/ou au dveloppement et  la reproduction du logiciel par l'utilisateur tant  donn sa spcificit de logiciel libre, qui peut le rendre complexe   manipuler et qui le rserve donc  des dveloppeurs et des professionnels avertis possdant  des  connaissances  informatiques approfondies.  Les utilisateurs sont donc invits  charger  et  tester  l'adquation  du logiciel  leurs besoins dans des conditions permettant d'assurer la scurit de leurs systmes et ou de leurs donnes et, plus gnralement,   l'utiliser et l'exploiter dans les mmes conditions de scurit.   

Le fait que vous puissiez accder  cet en-tte signifie que vous avez  pris connaissance de la licence CeCILL, et que vous en avez accept les termes. 

This software is a computer program whose purpose is to model energy systems.  

This software is governed by the CeCILL  license under French law and abiding by the rules of distribution of free software.  You can  use,  modify and/ or redistribute the software under the terms of the CeCILL license as circulated by CEA, CNRS and INRIA at the following URL "http://www.cecill.info".   

As a counterpart to the access to the source code and  rights to copy, modify and redistribute granted by the license, users are provided only with a limited warranty  and the software's author,  the holder of the economic rights,  and the successive licensors  have only  limited liability.   

In this respect, the user's attention is drawn to the risks associated with loading,  using,  modifying and/or developing or reproducing the software by the user in light of its specific status of free software, that may mean  that it is complicated to manipulate,  and  that  also therefore means  that it is reserved for developers  and  experienced professionals having in-depth computer knowledge. Users are therefore encouraged to load and test the software's suitability as regards their requirements in conditions enabling the security of their systems and/or  data to be ensured and,  more generally, to use and operate it in the  same conditions as regards security.   

The fact that you are presently reading this means that you have had knowledge of the CeCILL license and that you accept its terms.  
*/
package extThopt;

import java.util.*; 

import javax.swing.*;

import rg.corps.Corps;

public class FeedWaterReheater extends ExtDivider implements Inversable
{
    protected static java.util.ResourceBundle resIntTh_fr = java.util.ResourceBundle.getBundle("IntTh",Locale.getDefault());  
    
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JTextField inletEpsi_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JTextField epsi_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel3 = new javax.swing.JLabel();
	javax.swing.JTextField DeltaQprime_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel4 = new javax.swing.JLabel();
	javax.swing.JTextField water_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel5 = new javax.swing.JLabel();
	javax.swing.JTextField approach_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel6 = new javax.swing.JLabel();
	javax.swing.JTextField range_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel7 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel8 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel9 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel10 = new javax.swing.JLabel();
	javax.swing.JLabel JLabel11 = new javax.swing.JLabel();
	javax.swing.JTextField compRef = new javax.swing.JTextField();
	javax.swing.JCheckBox condPressureSet100 = new javax.swing.JCheckBox();
	javax.swing.JCheckBox temperatureTestOn = new javax.swing.JCheckBox();
    
    String feedWaterProcess,condProcess, mainPoint,condPoint;
    double condT,mainT,outletT,condP,waterH,qPrimeSatInEau,deltaQprime,deltaQprime0,flow_as,qPrimeAmont, condFlow, 
    mainFlow, lostWater, approach, range, UA;
    String linkProcess;
    FeedWaterReheaterInlet fwhi;
    String fwhiName="";
	double[] inletFlow={0,0};
	String[] outletPointNames={"",""};
	boolean debug=false;

    String amont;
    /**
     * @wbp.nonvisual location=191,64
     */
    private final JTextField pressureDrop_value = new JTextField();
    
    public FeedWaterReheater (){
        super();
		JPanel1.setLayout(null);
		JPanel1.setBounds(0,0,400,420);
		JLabel2.setText("epsilon value");
		JPanel1.add(JLabel2);
		JLabel2.setBounds(0,0,164,24);
		JPanel1.add(epsi_value);
		epsi_value.setBounds(164,0,124,24);
		epsi_value.setText("0.9");
		JLabel1.setText("inlet temperature");
		JPanel1.add(JLabel1);
		JLabel1.setBounds(0,30,164,24);
		JLabel3.setText("steam temperature");
		JPanel1.add(JLabel3);
		JLabel3.setBounds(0,55,164,24);
		JLabel4.setText("cond temperature");
		JPanel1.add(JLabel4);
		JLabel4.setBounds(0,80,164,24);
		JLabel5.setText("approach (C)");
		JLabel5.setBounds(0,105,164,24);
		JLabel6.setText("range (C)");
		JLabel6.setBounds(0,130,164,24);
		JLabel7.setText("epsilon");
		JLabel7.setBounds(200,30,300,24);
		JLabel8.setText("Pressure drop %");
		JPanel1.add(JLabel8);
		JLabel8.setBounds(200,55,120,24);
        pressureDrop_value.setText("3");
        pressureDrop_value.setColumns(10);
        JPanel1.add(pressureDrop_value);
        pressureDrop_value.setBounds(330,55,108,24);
		JPanel1.add(JLabel9);
		JLabel9.setBounds(200,80,108,24);
		JPanel1.add(JLabel10);
		JLabel10.setBounds(200,105,108,24);
		JPanel1.add(JLabel11);
		JLabel11.setBounds(200,130,200,24);
		JPanel1.add(condPressureSet100);
		condPressureSet100.setBounds(400,0,200,24);
		condPressureSet100.setText("cond pressure set");
		
		JPanel1.add(temperatureTestOn);
		temperatureTestOn.setBounds(400,25,200,24);
		temperatureTestOn.setText("Temperature test");
		temperatureTestOn.setSelected(false);
		type=getType();
		thermoCouplerTypes=new String[0];
 }
    
    public String getType(){
        return "Feedwater reheater with cascaded drain";
    }
    public String getCompType(){
        return getType();
    }

	public String getClassDescription(){
	    return "Closed feedwater heater with cascaded drains\n\nauthor : R. Gicquel  February 2025\n\nRef : FeedwaterReheaters.doc";
	}
    public void init(){
	    getDividerStructure();
        checkConsistency();
		setupInlet();
	    calculateProcess();
    }
    public double getDeltaQprime(){
        return deltaQprime;
    }
    public double getApproach(){
        return approach;
    }
    public double getRange(){
        return range;
    }
    public double getUA(){
        return UA;
    }
    public double getAirFlow(){
        return condFlow;
    }
    public double getlostWaterFlow(){
        return lostWater;
    }

	public void calculateProcess(){
	    
	    getDividerStructure();
        checkConsistency();
	    if(fwhi==null)setupInlet();
	    fwhi.calculateProcess();

	    if(isBuilt){
            Object obj=Corps.createSubstance(resIntTh_fr.getString("eau"));
            Corps eau=(Corps)obj;
            double P=fwhi.steamP;
            condP = 100;//first initialization
            
			if(fwhi.mainT>fwhi.condT){
	        	String mess="Watch out: the main temperature is greater than that of condensate "+fwhi.outletFwhName;
                JOptionPane.showMessageDialog(de,mess);
           	
            }
            double xSteam=0;
            JLabel1.setText("inlet temperature "+Util.aff_d(fwhi.mainT-273.15,2));
            JLabel3.setText("steam temperature "+Util.aff_d(fwhi.steamT-273.15,2));
            JLabel4.setText("cond temperature "+Util.aff_d(fwhi.condT-273.15,2));
            eau.CalcPropCorps(fwhi.steamT,fwhi.steamP , xSteam);
            double steamHl=eau.H;
            //enthalpie totale entrante ct condensats chauds
			//total incoming enthalpy on the hot condensate side
            double condH=steamHl*fwhi.steamFlow+fwhi.condH*fwhi.condFlow;
            double condFlow = fwhi.steamFlow+fwhi.condFlow;
            double hm=condH/condFlow;
            double Tcond=eau.getT_from_hP(hm, P);
			//calculation of the first heat exchanger
            double deltaTe=Tcond-fwhi.mainT;
            double epsilon=Util.lit_d(epsi_value.getText());
            double R=condFlow/fwhi.mainFlow;
            double argLn=(1-epsilon*R)/(1-epsilon);
            double NUT=1/(1-R)*Math.log(argLn);
            double deltaTmax=epsilon*deltaTe;
            double ToutCond = Tcond - deltaTmax;
            eau.CalcPropCorps(ToutCond,P , 0);
            double condHout=eau.H;
            double phi=(hm-condHout)*condFlow;
            double hmainInter=phi/fwhi.mainFlow+fwhi.mainH;
            double TmainInter=eau.getT_from_hP(hmainInter, fwhi.mainP);
            //Flux disponible par condensation
			//Flow available through condensation
            double steamCondH=(fwhi.steamH-steamHl)*fwhi.steamFlow;
            double hOut=hmainInter+steamCondH/fwhi.mainFlow;
            double Tout=eau.getT_from_hP(hOut, fwhi.mainP); 
	            if(true){
	            	System.out.println(fwhiName+  " condH "+condH+" condFlow "+condFlow); 
	                System.out.println(fwhiName+  " hm "+hm+" P "+P); 
	     	        System.out.println(fwhiName+  " deltaTmax "+deltaTmax+" deltaTe "+deltaTe); 
		            System.out.println(fwhiName+  " Tcond "+(Tcond-273.15)+" fwhi.mainFlow "+fwhi.mainFlow); 
		            System.out.println(fwhiName+  " hmainInter "+hmainInter+" TmainInter "+(TmainInter-273.15)); 
		          
		            System.out.println(fwhiName+  " condPoint "+condPoint+" mainPoint "+mainPoint); 
		            System.out.println(fwhiName+  " phi  "+phi+" mainP  "+fwhi.mainP); 
		            System.out.println(fwhiName+  " hOut "+hOut+" Tout "+(Tout-273.15)); 
		            System.out.println(fwhiName+ " fwhi.steamT "+(fwhi.steamT-273.15)); 
	           }
            if((temperatureTestOn.isSelected())&&(Tout>fwhi.steamT-1)){
	        	String mess="Watch out: the main temperature is greater than that of steam "+fwhi.outletFwhName+
	        			"\nYou should reduce the steam flow";
                JOptionPane.showMessageDialog(de,mess);
            }
            if(temperatureTestOn.isSelected()){//update of cond pressure if the test is set
            	condP=fwhi.steamP;
             	
            }
           
            if(debug){
            	System.out.println(fwhiName+  " deltaTmax "+deltaTmax+" deltaTe "+deltaTe); 
	            System.out.println(fwhiName+  " condFlow "+condFlow+" fwhi.mainFlow "+fwhi.mainFlow); 
	            System.out.println(fwhiName+  " hmainInter "+hmainInter+" TmainInter "+(TmainInter-273.15)); 
	          
	            System.out.println(fwhiName+  " condPoint "+condPoint+" mainPoint "+mainPoint); 
	            System.out.println(fwhiName+  " phi  "+phi+" mainP  "+fwhi.mainP); 
	            System.out.println(fwhiName+  " hOut "+hOut+" Tout "+(Tout-273.15)); 
           }
        	           
            String[]args={"",""};
            //mise  jour du lien entre les noeuds externes
            //update of the link between the external nodes
            args[0]="process";//type of the element (see method getProperties(String[] args))
            args[1]=mainProcess;//name of the process (see method getProperties(String[] args))
            Vector vProp=proj.getProperties(args);
            String dummy=(String)vProp.elementAt(2);// point name
            updatepoint(dummy, true, Tout,  //T
                false, 0, false, 0,//P,x
                false, "dummy", 1);
            
            
            //mise  jour du noeud en utilisant les mthodes gnriques
            //update of the node by the generic methods 
            vTransfo= new Vector[nBranches+1];
            vPoints= new Vector[nBranches+1];
            setupVector(condProcess, condPoint, 0, condFlow, ToutCond, condP, 0);
            setupVector(feedWaterProcess, mainPoint, 1, fwhi.mainFlow, Tout, fwhi.mainP, 0);
            setupVector(mainProcess, linkProcess, 2, condFlow+mainFlow, Tout, fwhi.mainP, 0);
            updateDivider(vTransfo,vPoints,Tout,hOut);
        }
	}
	
    public double f_dicho(double T, double P, String fonc){
         
        return 0;
        
    }
    
    /**
    * calculates NUT on the basis of the efficiency and R for counterflow configuration
    */
    double NUT_epsi(double epsilon, double R){
    	
        //cette mthode calcule le NUT  partir de epsilon et de R
        double X;
            if(R!=1){
                X=(1-epsilon*R)/(1-epsilon);
                return Math.log(X)/(1-R);
            }
            else return epsilon/(1-epsilon);
    }
    
double  epsi_NUT(double NUT, double R){
  //cette mthode calcule epsilon  partir du NUT et de R
  //en fonction du type d'changeur
  //this method calculates epsilon from the NTU and R
//depending on the type of exchanger
    double Expo;
    if(R!=1){
        Expo=-NUT*(1-R);
        return (1-Math.exp(Expo))/(1-R*Math.exp(Expo));
    }
    else return NUT/(1+NUT);
}
    
    
	public void readCompParameters(String ligne_data){
        String valeur=Util.extr_value(ligne_data, "water_value");
        if(valeur!=null)water_value.setText(valeur);
		valeur=Util.extr_value(ligne_data, "inletEpsi_value");
	    if(valeur!=null)inletEpsi_value.setText(valeur);
		valeur=Util.extr_value(ligne_data, "epsi_value");
	    if(valeur!=null)epsi_value.setText(valeur);
		valeur=Util.extr_value(ligne_data, "pressureDrop_value");
	    if(valeur!=null)pressureDrop_value.setText(valeur);
		valeur=Util.extr_value(ligne_data, "condPressureSet100");
	    if(valeur!=null)condPressureSet100.setSelected(Util.lit_b(valeur));
		valeur=Util.extr_value(ligne_data, "temperatureTestOn");
	    if(valeur!=null)temperatureTestOn.setSelected(Util.lit_b(valeur));
	}
	
    public String saveCompParameters(){
	    String h="inletEpsi_value="+inletEpsi_value.getText()+tab
	    +"epsi_value="+epsi_value.getText()+tab
	    +"pressureDrop_value="+pressureDrop_value.getText()+tab
	    +"water_value="+water_value.getText()+tab
	    +"condPressureSet100="+Util.aff_b(condPressureSet100.isSelected())+tab
	    +"temperatureTestOn="+Util.aff_b(temperatureTestOn.isSelected())+tab
	    ;
        return h;
    }
    
        private void checkConsistency(){
	    String[] args=new String[2];
	    Vector[] vBranch=new Vector[2];
        isBuilt=true;
        feedWaterProcess="";
        condProcess="";
        if(nBranches!=2){
	        String msg = "Error on the number of branches which is "+nBranches+" instead of 2";
	        JOptionPane.showMessageDialog(de, msg);  
	        isBuilt=false;
        }
        else{
            for(int j=0;j<nBranches;j++){
	            args[0]="process";//type of the element (see method getProperties(String[] args))
	            args[1]=nomBranche[j];//name of the process (see method getProperties(String[] args))
                vBranch[j]=proj.getProperties(args);
	            String amont=(String)vBranch[j].elementAt(1);//gets the downstream point name
	            getPointProperties(amont);//direct parsing of point property vector
                String nom=nomCorps;
                outletPointNames[j]=amont;
                //Check the substance at inlet
  //              System.out.println(" ligne "+j+" nomCorps "+nomCorps);
		   	    Double value=(Double)vBranch[j].elementAt(3);
	   	        inletFlow[j]=value.doubleValue();
		   	     System.out.println(fwhiName+  " nomBranche[j] "+nomBranche[j]+" j "+j);
		   	     System.out.println(fwhiName+  " inletFlow[j] "+inletFlow[j]+" j "+j);
		   	     System.out.println(fwhiName+  " outletPointNames[j] "+outletPointNames[j]+" j "+j);
	            
	        }
     	
    		if(inletFlow[1]>inletFlow[0]){
    			feedWaterProcess=nomBranche[1];
    			mainPoint=outletPointNames[1];
        		mainFlow=inletFlow[1];
    			condProcess=nomBranche[0];
    			condPoint=outletPointNames[0];
        		condFlow=inletFlow[0];
    		}
    		else{
    			feedWaterProcess=nomBranche[0];
    			mainPoint=outletPointNames[0];
        		mainFlow=inletFlow[0];
     			condProcess=nomBranche[1];
    			condPoint=outletPointNames[1];
        		condFlow=inletFlow[1];
    			
    		}
	        if((condProcess.equals(""))||(feedWaterProcess.equals(""))){
	            String msg = "Error on at least one of the branch substances";
	            JOptionPane.showMessageDialog(de, msg);  
	            isBuilt=false;
	        }
        }
        linkProcess=mainProcess;
        System.out.println(fwhiName+  " linkProcess out "+linkProcess); 
        
    }
    void setupInlet(){
        Vector vExt=proj.getExternalClassInstances();
        boolean test=false;
        for(int i=0;i<vExt.size();i++){
            Object[] obj=new Object[6];
	        obj=(Object[])vExt.elementAt(i);
	        String type=(String)obj[0];
	        if(type.equals("node")){
	            String main=(String)obj[4];
	            String nodeType=(String)obj[3];
	            if((main.equals(linkProcess))&&((nodeType.equals("Feedwater reheater inlet")))){
	                fwhi=(FeedWaterReheaterInlet)obj[1];
	                fwhiName=(String)obj[2];
	                if(fwhi!=null)test=true;
	            }
	        }
        }
         if(!test){
	        String msg = "Impossible to build the inlet node.\nCheck that its class is available in extThopt2.zip or extUser2.zip";
	        JOptionPane.showMessageDialog(new JFrame(), msg);  
        }
 }
 
}