package extThopt;

import extThopt.*;

import java.util.*; 

import javax.swing.*;

/**
 * classe HTE_25
 * 
 */
public class HTE_25 extends ExtDivider implements java.awt.event.ActionListener //implements Inversable
{
    
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JTextField alpha_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JTextField rendement_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel3 = new javax.swing.JLabel();
	javax.swing.JTextField  Pelec_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel4 = new javax.swing.JLabel();
	javax.swing.JTextField Tout_value = new javax.swing.JTextField();
	javax.swing.JLabel JLabel5 = new javax.swing.JLabel();
	javax.swing.JLabel Q_value = new javax.swing.JLabel();
	javax.swing.JLabel JLabel6 = new javax.swing.JLabel();
	javax.swing.JLabel debitmol_value = new javax.swing.JLabel();
	javax.swing.JRadioButton bMode1 = new javax.swing.JRadioButton();
	javax.swing.JRadioButton bMode2 = new javax.swing.JRadioButton();
	javax.swing.JRadioButton bMode3 = new javax.swing.JRadioButton();
	final ButtonGroup groupCalcType=new ButtonGroup();
    
    double Pentree, Minlet, tout;
    double massFlow, molFlow, Tentree, Hentree, fracH2entree, nelectrolysee, nO2;
    double alpha,beta, tau, rendement1, rendement2,deltaH,deltaH0, Q, Hfinal, Tfinal;
    double n_H2in, n_H2O_in, n_H2out, n_H2O_out, P_elec, U_cell, I_total;
    String entreeProcess,outletH2Process,outletO2Process;
    String entreePoint,outletH2Point,outletO2Point;
    rg.corps.Corps outletH2Substance;
    Vector inputComp, outH2H2OComp;    
        
    String[]gasComp={"H2","H2O"};
    double[]molMass={2.01588,18.01528};
    double O2_M=31.9988;   
    double F = 96485.3321;// s A / mol
    double eta_F = 0.98;
    
    public HTE_25(){
        super();
 		JPanel1.setLayout(null);
		JPanel1.setBounds(0,0,600,200);
		
		bMode1.setText("Calculation with given \u03b1");
		JPanel1.add(bMode1);
		bMode1.setBounds(350,0,200,20);
		bMode2.setText("Calculation with given Pelec");
		JPanel1.add(bMode2);
		bMode2.setBounds(350,24,200,20);
		bMode3.setText("Calculation with given T and \u03b1");
		JPanel1.add(bMode3);
		bMode3.setBounds(350,48,180,20);
		bMode3.setVisible(false);
	    groupCalcType.add(bMode1);
	    groupCalcType.add(bMode2);
	    groupCalcType.add(bMode3);
	    bMode1.setSelected(true);
	    bMode1.addActionListener(this);
	    bMode2.addActionListener(this);
	    bMode3.addActionListener(this);
		
		JLabel2.setText("H2 specific consumption kWh/Nm3");
		JPanel1.add(JLabel2);
		JLabel2.setBounds(0,0,200,20);
		JPanel1.add(rendement_value);
		rendement_value.setBounds(200,0,124,20);
		rendement_value.setText("3.2");
		JLabel1.setText("Outlet H2 molar fraction \u03b1");
		JPanel1.add(JLabel1);
		JLabel1.setBounds(0,24,200,20);
		JPanel1.add(alpha_value);
		alpha_value.setBounds(200,24,124,20);
		alpha_value.setText("0.5");
		JLabel3.setText("Pelec provided (kW)");
		JPanel1.add(JLabel3);
		JLabel3.setBounds(0,48,200,20);
		JPanel1.add(Pelec_value);
		Pelec_value.setBounds(200,48,124,20);
		Pelec_value.setText("0");
		JLabel4.setText("Outlet temperature (C)");
		JPanel1.add(JLabel4);
		JLabel4.setBounds(0,72,200,20);
		JPanel1.add(Tout_value);
		Tout_value.setBounds(200,72,124,20);
		Tout_value.setText("950");
		JLabel5.setText("Thermal load (kW)");
		JPanel1.add(JLabel5);
		JLabel5.setBounds(0,96,200,20);
		JPanel1.add(Q_value);
		Q_value.setBounds(200,96,124,20);
		Q_value.setText("0.2");
		JLabel6.setText("H2 converted flow rate (kg/s)");
		JPanel1.add(JLabel6);
		JLabel6.setBounds(0,120,200,20);
		JPanel1.add(debitmol_value);
		debitmol_value.setBounds(200,120,124,20);
		debitmol_value.setText("30");
		type=getCompType();
   		thermoCouplerTypes=new String[1];//one thermocoupler connected
 		thermoCouplerTypes[0]="thermal load";
		setExergyExtensor(true);
    }
    public void init(){
    	    	
	    getDividerStructure();
        checkConsistency();
	//	setExergyExtensor(true);

		}
    
    public String getCompType(){
        return "HTE_25";
    }
    
	public String getClassDescription(){
	    return "HTE_25 model \n divider\nwith thermocoupler\n\nauthor : R. Gicquel mars 2005\n\nRef : archive HTE_25.zip";
	}
    
     public void actionPerformed(java.awt.event.ActionEvent e){
        Object o=e.getSource();
        if(o.equals(bMode1)){
            Pelec_value.setEditable(false);
            alpha_value.setEditable(true);
            Tout_value.setEditable(false);
            JPanel1.repaint();
        }
        if(o.equals(bMode2)){
            Pelec_value.setEditable(true);
            Tout_value.setEditable(false);
            alpha_value.setEditable(false);
            JPanel1.repaint();
        }
        if(o.equals(bMode3)){
            Pelec_value.setEditable(false);
            Tout_value.setEditable(true);
            alpha_value.setEditable(true);
            JPanel1.repaint();
        }
     }
        
	public void calculateProcess(){
		
		getDividerStructure();
 	    checkConsistency();
 	     	    
		beta=fracH2entree;
				
        if((isBuilt)){//si le noeud externe est bien configur
            double molFlow=massFlow/Minlet;
	     	deltaH0=246;//241.8; //en kJ/mol de H2 produite  900C
	     	
	     	n_H2in = molFlow * beta;
	     	n_H2O_in = molFlow * (1 -beta);
	     	eta_F = 0.9;
	     	
	     	U_cell = 1.253 - 2.4516e-4 * Tentree;	     	
	     	
	     	if(bMode1.isSelected()){//calcul la tranformation  partir de alpha
		        //lecture de la fraction molaire de sortie alpha
		        alpha=Util.lit_d(alpha_value.getText()); 
		        nelectrolysee=(alpha-beta)*molFlow;
	     	    		
		     	I_total = nelectrolysee * 2 * F / (eta_F );
		     	P_elec = U_cell * I_total;
	            Pelec_value.setText(Util.aff_d(P_elec/1000,3));    	     		
	     	}
	     	else if(bMode2.isSelected()){
		        //lecture de P_elec
	     		P_elec=Util.lit_d(Pelec_value.getText())*1000; 
	     		I_total = P_elec / U_cell ;
	     		nelectrolysee = I_total  * eta_F  / (2 * F );
	     		
	     	    alpha=beta+nelectrolysee/molFlow;
		        alpha_value.setText(Util.aff_d(alpha,3)); 
	     	}

		    //calcul du taux de dcomposition de l'eau
		    tau=(alpha-fracH2entree)/(1-fracH2entree);
		    
	     	nO2=nelectrolysee/2;
	     	n_H2out = n_H2in + nelectrolysee;
	     	n_H2O_out = n_H2O_in - nelectrolysee;
	     	tau = nelectrolysee / n_H2O_in;
     	    double deltaH_reaction = nelectrolysee * deltaH0;
     	    double TdeltaS = 61.491 * Tentree/1000	- 6.2334;

     	    Q = nelectrolysee * TdeltaS * 1000;// Q = - T Delta S
    	    deltaH = Q + P_elec;
	     	double deltaG = -55.578 * Tentree/1000+ 248.08;

	     	deltaG = deltaG		* nelectrolysee;
    		//calcul du rendement en kJ/mol  partir du rendement en kWh/Nm3
			rendement2=P_elec/nelectrolysee/22.414/3600;//densit  0 C, 1 atm
			rendement_value.setText(Util.aff_d(rendement2,3)); 
	     	debitmol_value.setText(Util.aff_d(nelectrolysee*2.0159,3));
	     	

	       	double nH2sortie=fracH2entree*molFlow+nelectrolysee;
	     	double xH2=nH2sortie/molFlow;
	     	System.out.println("U_cell: " + U_cell+ " I_total: " + I_total+ " P_elec: " + P_elec
	     			+ " rendement2: " + rendement2+ " Q: " + Q+ " beta: " + beta
	     			+ " deltaG: " + deltaG+ " nelectrolysee: " + nelectrolysee
	     			+ " xH2: " + xH2); 
	        outH2H2OComp=initGasComp(gasComp,molMass);
            Util.updateMolarComp(outH2H2OComp,gasComp[0], xH2);
            Util.updateMolarComp(outH2H2OComp,gasComp[1], 1.-xH2);
            outletH2Substance.updateGasComposition(outH2H2OComp);
                
            getPointProperties(outletH2Point);
            getSubstProperties(nomCorps);
            double outH2H2OM=Msubst;//masse molaire du gaz  traiter
	     	
            getPointProperties(entreePoint);
            getSubstProperties(nomCorps);
            //on prend en compte une petite augmentation de la chaleur apporte 
            //pour viter d'avoir un thermocoupleur isotherme
            //et pour qu'il y ait de la marge sur le circuit de rcupration
	     	Hfinal=Hentree + Q/massFlow*0.05;
	    // 	Hfinal=Hentree;
	       	Tfinal=lecorps.getT_from_hP(Hfinal,Pentree);
	        Tout_value.setText(Util.aff_d(Tfinal-273.15,3));
	     	System.out.println(" nentree "+molFlow+" Tsortie "+Tfinal+" Hsortie "+Hfinal+" Q "+Q);
	     	
	  		tauPlus=P_elec;
          
	     //   deltaXhi=Q; 
	        xqPlus=Q*(1-295/Tfinal);
	        etaExer=1.-deltaXhi/tauPlus;
/*	
			DeltaXhPlus_value.setValue(exergyBalance[1],precision);
			xqPlus_value.setValue(exergyBalance[2],precision);
			tauProduct_value.setValue(exergyBalance[3],precision);
			deltaXhProduct_value.setValue(exergyBalance[4],precision);
			etaExer_value.setValue(exergyBalance[5],precision+2);
			deltaXhi_value.setValue(exergyBalance[6],precision);
     	*/
	     	
	        Q_value.setText(Util.aff_d(Q/1000,3));
	     	
	        vTransfo= new Vector[nBranches+1];
	        vPoints= new Vector[nBranches+1];
	        setupVector(outletH2Process, outletH2Point, 0, molFlow*outH2H2OM, Tfinal, Pentree, alpha);
	        setupVector(outletO2Process, outletO2Point, 1, nO2*O2_M, Tfinal, Pentree, 1);
	        setupVector(entreeProcess, entreePoint, 2, massFlow, Tentree, Pentree, beta);
            updateDivider(vTransfo,vPoints,Tentree,Hentree);
	        de.updateProcess(setEnergyTypes(entreeProcess,P_elec,P_elec + Q,0));
            updateThermoCoupler("thermal load", Tentree, Tfinal, Q*1.05, massFlow,true,10);//true : pinchFluid, 10 : DTpinch
       }
        
	}
	    public Vector initGasComp(String[]gasComp,double[]molMass){
        int nb_comp=gasComp.length;
        Vector vComp=new Vector();
        Double[]fracMol= new Double[nb_comp],fracMass= new Double[nb_comp],molarMass= new Double[nb_comp];
        for(int j=0;j<nb_comp;j++){
	        fracMol[j]=new Double(0);
	        fracMass[j]=new Double(0);
	        molarMass[j]=new Double(molMass[j]);
        }
        vComp.addElement(new Integer(nb_comp));
        vComp.addElement(gasComp);
        vComp.addElement(fracMol);
        vComp.addElement(fracMass);
        vComp.addElement(molarMass);
        return vComp;
    }
	

    private void checkConsistency(){
	    String[] args=new String[2];
	    Vector[] vBranch=new Vector[2];
        isBuilt=true;
        outletO2Process="";
        outletH2Process="";
        if(nBranches!=2){
	        String msg = "Error on the number of branches which is "+nBranches+" instead of 3";
	        JOptionPane.showMessageDialog(de, msg);  
	        isBuilt=false;
        }
        else{
            for(int j=0;j<nBranches;j++){
	            args[0]="process";//type of the element (see method getProperties(String[] args))
	            args[1]=nomBranche[j];//name of the process (see method getProperties(String[] args))
                vBranch[j]=proj.getProperties(args);
	            String amont=(String)vBranch[j].elementAt(1);//gets the upstream point name
	            getPointProperties(amont);//direct parsing of point property vector
                getSubstProperties(nomCorps);
                
                if(typeSubst==3){//le corps d'entre est un gaz pur
                    String nom=nomCorps;
                    //Check the substance at inlet
                        if(nom.equals("O2")){
                        outletO2Process=nomBranche[j];
                        outletO2Point=amont;                
	                }
	            }
                else if(typeSubst==4){//le corps d'entre est un gaz compos
                    Vector vComp=lecorps.getGasComposition();
                    String[]components=(String[])vComp.elementAt(1);
                    if((components.length==2)&&(Util.contains(vComp,"H2"))&&(Util.contains(vComp,"H2O"))){
            	        outletH2Process=nomBranche[j];
            	        outletH2Point=amont;   
            	        args=new String[2];
                        args[0]="process";//type of the element (see method getProperties(String[] args))
                        args[1]=outletH2Process;//name of the process (see method getProperties(String[] args))
                        Vector vProp=proj.getProperties(args);
                        amont=(String)vProp.elementAt(1);//gets the upstream point name
                        getPointProperties(amont);//direct parsing of point property vector
	                    outletH2Substance=lecorps;
            	    }
            	}
            }
            if((outletO2Process.equals(""))|| (outletH2Process.equals(""))){
            String msg="Error on at least one of the branch substances";
            JOptionPane.showMessageDialog(de, msg);  
	        isBuilt=false;
            }
        }

	    entreeProcess=mainProcess;
        System.out.println(" entreeProcess "+entreeProcess);
	            
	    args[0]="process";//type of the element (see method getProperties(String[] args))
	    args[1]=entreeProcess;//name of the process (see method getProperties(String[] args))
	    Vector vPropMain=proj.getProperties(args);
	    
	    Double f=(Double)vPropMain.elementAt(3);
	    massFlow=f.doubleValue(); //dbit d'entre
	    String aval=(String)vPropMain.elementAt(2);//gets the downstream point name
	    getPointProperties(aval);//direct parsing of point property vector
	    entreePoint=aval;
	    Tentree=Tpoint;
	    Pentree=Ppoint;
	    Hentree=Hpoint;
	    getSubstProperties(nomCorps);
	    boolean testMain=false;
	    if(typeSubst==4){//le corps de sortie est un gaz compos
	        inputComp=lecorps.getGasComposition();//composition du gaz d'entre
            String[]components=(String[])inputComp.elementAt(1);
            if((components.length==2)&&(Util.contains(inputComp,"H2"))&&(Util.contains(inputComp,"H2O"))){
	            fracH2entree=Util.molarComp(inputComp,"H2"); //fraction molaire de H2
	            Minlet=Msubst;
	            testMain=true;
	        }
        }
	    if(!testMain){
        	String msg="Error on main process substance composition";
        	JOptionPane.showMessageDialog(de, msg);  
	        isBuilt=false;	
	    }
    }


    
    public void readCompParameters(String ligne_data){
        String valeur=Util.extr_value(ligne_data, "alpha_value");
        if(valeur!=null)alpha=Util.lit_d(valeur);
	    alpha_value.setText(Util.aff_d(alpha,3));
	    valeur=Util.extr_value(ligne_data, "eta_value");
        if(valeur!=null)rendement_value.setText(valeur);
		double deltaH=Util.lit_d(Util.extr_value(ligne_data, "Pelec_value"));
	    Pelec_value.setText(Util.aff_d(deltaH,2));
		double Tfinal=Util.lit_d(Util.extr_value(ligne_data, "Tout_value"));
	    Tout_value.setText(Util.aff_d(Tfinal,2));
		double debitmol=Util.lit_d(Util.extr_value(ligne_data, "debitmol_value"));
	    debitmol_value.setText(Util.aff_d(debitmol,2));
	    valeur=Util.extr_value(ligne_data, "modeCalc");
        if(valeur!=null){
        	try {
        	int iCalc=Util.lit_i(valeur);
            if(iCalc==1)bMode1.setSelected(true);
            if(iCalc==2)bMode2.setSelected(true);
            if(iCalc==3)bMode3.setSelected(true);
        	 } catch (NumberFormatException e) {
        		 bMode1.setSelected(true);
             }
        }
	}
	
    public String saveCompParameters(){
	    String h="";
	    int iCalc=1;
	    if(bMode2.isSelected())iCalc=2;
	    if(bMode3.isSelected())iCalc=3;
	    h=h
	    +"alpha_value="+alpha_value.getText()+tab
	    +"eta_value="+rendement_value.getText()+tab
	    +"Pelec_value="+Pelec_value.getText()+tab
	    +"Tout_value="+Tout_value.getText()+tab
	    +"debitmol_value="+debitmol_value.getText()+tab
	    +"modeCalc="+Util.aff_i(iCalc)+tab
	    ;
        return h;
    }
 
   
}